
#|____________________________________________________________________
 |
 |         RMDS.LSP - Replicated Multidimensional Scaling
 |              Copyright (c) 1997, Forrest W. Young
 |                         VISUALIZATION
 |____________________________________________________________________
 |#


(defmeth rmds-model-proto :visualize ()
  ;(setf container (make-container :free t :type 1 :local-menus t :show nil))
  ;(enable-container container)
  (setf *nrmds-spreadplot-container* (create-spreadplot-container))
  (let* ((2-d (send self :2d-plot))
         (3-d (send self :3d-plot))
         (scatmat (send self :sm-plot))
         (stress (send self :mds-stress-plot))
         (data-dist (send self :plot-data-dist))
         (name (send self :name-plot))
         (xd (send self :mds-x-change-plot))
         (sd (send self :mds-s-change-plot))
         (td (send self :mds-t-change-plot))
         (splot (spread-plot 
                 (matrix (list 3 4) (list scatmat   3-d     2-d name 
                                          data-dist stress  xd  nil
                                          nil       sd      td  nil))
                 :rel-widths (list 1 1 1 .4)
                 :rel-heights (list 1 .5 .5)
                 :span-down  #2a((1 1 1 3)(2 1 1 0)(0 1 1 0))
                 :statistical-object self
                 :container *nrmds-spreadplot-container*))
         )
    (send self :color-data-distances-plot data-dist)
    (send 2-d :mouse-mode 'brushing)
    (send 3-d :mouse-mode 'brushing)
    (send name :mouse-mode 'brushing)
    (send splot :show-spreadplot)
    (send scatmat :linked t)
    (send 2-d :linked t)
    (send 3-d :linked t)
    (send name :linked t)
    (disable-container)
    ))
         

(defmeth rmds-model-proto :2d-plot ()
  (let ((pp (plot-points (col (send self :x) 
                              (iseq (send self :dimensions)))
                :show nil
                :scale-type 'fixed
                :title "Stimulus Plane"
                :variable-labels (list "Dimension 1" "Dimension 2" 
                      "Dimension 3" "Dimension 4" "Dimension 5" "Dimension 6" 
                      "Dimension 7" "Dimension 8" "Dimension 9")
                :point-labels (send self :stimulus-names)))) 
    (send pp :point-symbol (iseq (send pp :num-points)) 'square)
    (send pp :use-color t)
    (send pp :point-color (iseq (send pp :num-points)) 'blue)
    (send pp :showing-labels t)
    (send pp :linked t)
    (send pp :margin 0 17 0 0)
    (send pp :add-overlay (send vista-graph-overlay-proto 
                                :new :new-x nil :new-y nil :undo t))
    (send pp :add-mouse-mode 'point-moving
        :title "Drag Point"
          :cursor 'finger
          :click :do-point-moving)
 
    (send pp :adjust-to-data)
    (setf minppxy (min (combine (col (send self :x) 
                                   (iseq (send self :dimensions))))))
    (setf maxppxy (max (combine (col (send self :x) 
                                   (iseq (send self :dimensions))))))
    (setf gnrpp (get-nice-range minppxy maxppxy 5))
    (send pp :range 0 (first gnrpp) (second gnrpp) :draw nil)
    (send pp :range 1 (first gnrpp) (second gnrpp) :draw nil)
    (send pp :x-axis t t (third gnrpp) :draw nil)
    (send pp :y-axis t t (third gnrpp) :draw nil)
    (send pp :legend2 "Stimulus Plane")

    (defmeth pp :do-point-moving (x y a b)
      (let* ((pti      (send self :drag-point x y))
             (xvaryvar (send self :content-variables))
             (xvar     (first  xvaryvar))
             (yvar     (second xvaryvar))
             (x nil)
             (y nil))
        (when pti
              (setf x (send self :point-coordinate xvar pti))   
              (setf y (send self :point-coordinate yvar pti))
              (send 
		(send
			(send pp :spreadplot-object)
		:statistical-object) 
	       :use-new-point pti xvar yvar x y)
              )))

    (defmeth pp :undo-graph-change (m1 m2)
      (cond
        (m1 (send *mds* :back-to-start))
        (t  (send *mds* :back-just-one)))
    )

    ;next two were scatterplot-proto methods

    (defmeth pp :add-lines-with-points (&key (color 'black))
      (let* ((ps (send self :num-points)))
        (send self :clear-lines :draw nil)
        (send self :add-lines (send self :point-coordinate 0 (iseq ps))
              (send self :point-coordinate 1 (iseq ps)) :color color)
        (send self :redraw)))
         
    (defmeth pp :do-nothing (x y m1 m2)
      (let* ((xscore (select (send self :canvas-to-real x y) 0))
             (yscore (select (send self :canvas-to-real x y) 1))
             (xvar (select (send pp :current-variables) 0))
             (yvar (select (send pp :current-variables) 1))
             (i (send pp :points-selected)))
        (when (or (> (length i) 1)
                  (< (length i) 1))
              (message-dialog "You must select exactly 1 point to be relocated"))
        (when (= (length i) 1)
              (send (send (send pp :spreadplot-object) :statistical-object) :use-new-point i xvar yvar xscore yscore))))

    (defmeth pp :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "The STIMULUS PLANE plot is a scatterplot that shows a 2-dimensional view of the MDS stimulus space.~2%"))
      (paste-plot-help (format nil "The plot is like other scatterplots, except it has a special mouse mode which is designed to help you guide the iterative process. In addition, the plot has an UNDO button to undo the changes you make to the iterative process.~2%"))
      (paste-plot-help (format nil "DRAG POINT~%The MOUSE button can be used to obtain a dialog box presenting the selection of mouse modes. The DRAG POINT mouse mode allows you to drag individual points to new locations in the plot. Simply locate your cursor (a pointing finger) on a point, and drag it to a new location. Each time you do this, ViSta will display the point's new postion in the STIMULUS PLANE MATRIX and STIMULUS SPACE windows, and will recalculate and display the new Stress value in the STRESS window.~2%"))
      (paste-plot-help (format nil "UNDO BUTTON~%The UNDO button can be used to undo the changes created by the DRAG POINT mouse mode. If you click on the button, the last point-move is undone. A shift-click undoes all changes and returns the space to its initial state.~2%"))  
      (show-plot-help))
    (send pp :redraw)
    pp)
)


(defmeth rmds-model-proto :sm-plot (&optional (stream t))
  (setf sm (scatterplot-matrix (col (send self :x) (iseq (send self :dimensions)))
                               :show nil
                      :title "Stimulus Plane Matrix"
                      :variable-labels (list "Dim1" "Dim2" 
                        "Dim3" "Dim4" "Dim5" "Dim6" "Dim7" "Dim8" "Dim9")                          
                      :point-labels (send self :stimulus-names)
                      ))
  (send sm :linked t)
  (send sm :point-symbol (iseq (send sm :num-points)) 'square)
  (send sm :use-color t)
  (send sm :point-color (iseq (send sm :num-points)) 'blue)
  (send sm :margin 0 17 0 0)
  (send sm :add-overlay (send vista-graph-overlay-proto 
                                       :new :new-x nil :new-y nil))
  (send sm :adjust-to-data)

  (defmeth sm :do-variable-focus (x y m1 m2)
"Method to focus on variable subplots modified to work for mds-model. Assumes that two other plots exist.  These plots MUST be named pp (the scatterplot) and sp (the spin-plot).  A click on a subplot sends it to scatterplot.  Two or three shift-clicks send first three selected variables to spin-plot and first two to scatterplot."
    (let ((cur-var (send self :current-variables))
          (pp (third (send (send self :spreadplot-object) :all-plots)))
          (sp (fourth (send (send self :spreadplot-object) :all-plots)))
          )
      (when (not m1)
            (when (/= (select cur-var 0) (select cur-var 1))
                  (send pp :current-variables 
                        (select cur-var 0) (select cur-var 1) )
                  (send pp :range (select cur-var 0) (first gnrpp) (second gnrpp) :draw nil)
                  (send pp :range (select cur-var 1) (first gnrpp) (second gnrpp) :draw nil)
                  (send pp :x-axis t t (third gnrpp) :draw nil)
                  (send pp :y-axis t t (third gnrpp) :draw t)
                  )
            (setf spin-var ())
            )
      (when m1
            (when (= (select cur-var 0) (select cur-var 1))
                  (setf cur-var (list (select cur-var 0))))
            (when (< (length spin-var) 3)
                  (setf spin-var (adjoin (select cur-var 0) spin-var))
                  (when (< (length spin-var) 3)
                        (if (equal (length cur-var) 2)
                            (setf spin-var 
                                  (adjoin (select cur-var 1) spin-var)))))
            (when (= (length spin-var) 3)
                  (send sp :transformation nil :draw nil)
                  (send pp :current-variables 
                        (select spin-var 0) (select spin-var 1) )
                  (send pp :range 0 (first gnrpp) (second gnrpp) :draw nil)
                  (send pp :range 1 (first gnrpp) (second gnrpp) :draw nil)
                  (send pp :x-axis t t (third gnrpp) :draw nil)
                  (send pp :y-axis t t (third gnrpp) :draw nil)
                  (setf spin-var (reverse spin-var))
                  (send sp 
                        :current-variables (select spin-var 0)
                        (select spin-var 1) (select spin-var 2)
                        :draw nil)
                  (send sp :add-box) ;ng
                  ;(send sp :adjust-to-data)
                  (let ((cur-var (send sp :current-variables))
                        )
                    (send sp :set-variables-with-labels cur-var
                          (select (send sp :variable-labels) cur-var))
                    )
                  
                  (setf spin-var ())
                  )
            )
      ))

  (send sm :add-mouse-mode 'focus-on-variables
        :title "Focus On Variables"
        :click :do-variable-focus
        :cursor 'finger)

  (send sm  :mouse-mode 'focus-on-variables)
  sm)

(defmeth rmds-model-proto :3d-plot (&optional (stream t))
  (setf *mds* self)
  (setf sp (spin-plot 
            (col (send self :x) 
                 (iseq (send self :dimensions)))
            :show nil
            :title "Stimulus Space"
            :variable-labels 
            (list "Dim1" "Dim2" "Dim3" "Dim4" "Dim5" "Dim6" "Dim7" "Dim8" "Dim9")
            :point-labels (send self :stimulus-names)
            :scale-type 'fixed))
  (let* ((h (+ (send sp :text-ascent)
               (send sp :text-descent))))
    )
  
  (send sp :scale-type 'centroid-fixed)
  (send sp :add-box) ;ok but ng for switched plots
  (send sp :switch-add-box)
  (send sp :mouse-mode 'hand-rotate)
  (send sp :depth-cuing nil)
  (send sp :point-symbol (iseq (send sp :num-points)) 'square)
  (send sp :use-color t)
  (send sp :point-color (iseq (send sp :num-points)) 'blue)
  (send sp :showing-labels t)
  (send sp :linked t)
  (send sp :add-overlay (send vista-graph-overlay-proto 
             :new :new-x nil :new-y nil :box t :iterate t :undo t))
  (send sp :set-variables-with-labels '(0 1 2)
                   (select (send sp :variable-labels) '(0 1 2)))

  (defmeth sp :iter8 () ;this has to be reworked
    (let* ((n (array-dimension (send *mds* :xmatrix) 0))
           (m (array-dimension (send *mds* :xmatrix) 1)))
      (send (send (send self :spreadplot-object) :statistical-object)  :prev-matrix (matrix (list n m)
              (copy-list (combine (send *mds* :xmatrix))))))
    (send (send (send self :spreadplot-object) :statistical-object)  :prev-stress (last (send (send (send self :spreadplot-object) :statistical-object)  :stress-list)))
    (setf iter-number (get-value-dialog "How many iterations?"
                                        :initial 5))
    (send *mds* :x (send *mds* :xmatrix));pv
    (dotimes (i (select iter-number 0))
             (let* ((n (array-dimension (send *mds* :xmatrix) 0))
                    (m (array-dimension (send *mds* :xmatrix) 1))
                    (trys (send stressp :num-points))
                    (old (matrix (list n m) 
                                 (copy-list (combine 
                                             (send *mds* :xmatrix)))))
                   ; (new (guttman-transform (send *mds* :xmatrix)))
                    )
               (setf args (send *mds* :iteration)) ;pv
               (setf new (send *mds* :X))
               (setf stress2 (last (send *mds* :stress-list)));pv
                    
               (send *mds* :update-simple-plot-transformed-data args)
               (send stressp :start-buffering)
               (send stressp :clear-points)
               (send stressp :clear-lines)
               (send stressp :add-points
                     (iseq (length (send *mds* :stress-list)))
                     (send *mds* :stress-list) :color 'red)
               (send stressp :point-label (iseq (length (send *mds* :stress-list)))
                     (mapcar '(lambda (el)
                                (format nil "~5,4f" el))
                             (send *mds* :stress-list)))
               (send stressp :add-lines (iseq (length (send *mds* :stress-list)))
                     (send *mds* :stress-list) :color 'red)
               (send stressp :point-state 
                     (- (length (send *mds* :stress-list)) 2) 'normal);pv
               (send stressp :point-state 
                     (- (length (send *mds* :stress-list)) 1) 'selected);pv
               (send stressp :adjust-to-data)
               (send stressp :redraw)
               (send stressp :buffer-to-screen)
               ;(send *mds* :stress stress2) pv
               (send *mds* :old-matrix old)
               (send *mds* :xmatrix new))
             (send *mds* :new-sm-points)
             (send *mds* :new-sp-points)
             (send *mds* :new-pp-points)
             ))

  (defmeth sp :plot-help ()
    (plot-help-window (strcat "Help for " (send self :title)))
    (paste-plot-help (format nil "The STIMULUS SPACE window is a SpinPlot showing a 3-dimensional view of the stimulus space. The general details of how to use this plot are given below. There are several specific details for the multidimensional scaling SpinPlot that are mentioned first.~2%"))
(paste-plot-help (format nil "SPECIFIC MDS SPINPLOT HELP~2%"))
(paste-plot-help (format nil "The MDS SpinPlot has two special buttons at the top. These are the ITER and UNDO buttons. They both control the iterative process used to optimally locate the stimulus points.~2%"))
(paste-plot-help (format nil "ITER BUTTON~%When you click on the ITER button you will see a dialog window that lets you enter the maximum number of iterations to be performed. When you specify a number and click OK, the iterations will take place. You will see stimulus points move in the three windows that provide views of the stimulus space (SCATMAT, STIMULUS SPACE and STIMULUS PLANES), and you will see new Stress values added to the STRESS window.~2%"))
(paste-plot-help (format nil "UNDO BUTTON~%The UNDO button undoes iterations. There are three ways this button can be used.~%CLICK: If you simply click on it, the last group of iterations is undone (a group of iterations is the set of iterations that were performed the last time you used the ITER button).~%SHIFT-CLICK: If you shift-click on the button, all iterations are undone and the space is returned to its initial state.~%OPTION-CLICK: If you option-click on the button the last iteration is undone (this provides a way to rock back and forth between the last two iterations).~2%"))
(paste-plot-help (format nil "GENERAL SPINPLOT HELP~2%"))
    (show-plot-help)
    (call-next-method :flush nil)
    )

  (defmeth sp :undo-graph-change (m1 m2)
    (cond
      (m1 (send *mds* :back-to-start))
      (m2 (send *mds* :back-just-one))
      (t  (send *mds* :undo-iterations))))
    
      
  (defmeth sp :set-variables-with-labels (v labs)                                 
    (let ((n (send self :num-variables)))                                   
      (send self :variable-label (iseq n) (repeat "" n))             
      (send self :variable-label v labs)                                           
      (apply #'send self :current-variables v)
      ))
  sp)

(defmeth rmds-model-proto :matrices-numbers ()
  (iseq (length (send self :data))))

(defmeth rmds-model-proto :mds-stress-plot (&optional (stream t))
  (let ((num-dims (send self :dimensions))
        (num-mats (length (send self :matrices-numbers)))
        )
    (setf stressp (plot-points 
                   (iseq (length (send self :stress-list))) 
                   (send self :stress-list)
                   :show nil
                   :title "Stress Plot"
                   :variable-labels (list "Iteration" "Stress")))
    (send stressp :margin 0 17 0 0)
    (send stressp :add-overlay (send vista-graph-overlay-proto 
                                     :new :mouse-mode nil :new-x nil :new-y nil))
    (send stressp :showing-labels t)
    (send stressp :point-label 
          (iseq (send stressp :num-points))
          (mapcar #'(lambda (st) (format nil "~5,4f" st)) 
                  (send self :stress-list)))
    (send stressp :point-state 0 'selected)
    (send stressp :use-color t)
    (send stressp :point-color 0 'red)
    (send stressp :mouse-mode 'brushing)
    (send stressp :range 0 0 5)
    (send stressp :x-axis t t 6)
    (send stressp :menu nil)
    (send stressp :legend2 "Stress Plot")
    (send stressp :add-lines 
          (iseq (length (send self :stress-list))) 
          (send self :stress-list)
          :color 'red)
    (send stressp :adjust-to-data)

    (defmeth stressp :redraw ()
      (let* ((maxy (max (send stressp :point-coordinate 1 
                              (iseq (send stressp :num-points)))))
             (gnrx nil)
             )
        (when (> (send self :num-points) (second (send self :range 0)))
              (setf gnrx 
                    (get-nice-range 0 (+ 5 (second (send self :range 0))) 5))
              (send self :range 0 (first gnrx) (second gnrx) :draw nil)
              (send self :x-axis t t (third gnrx) :draw nil))
        (send stressp :range 1 0  (* .1 (ceiling (* 10 maxy))) :draw nil)
        (send stressp :y-axis t t (1+   (ceiling (* 10 maxy))) :draw nil)
        (call-next-method)))

    (defmeth stressp :add-lines-with-points (&key (color 'black))
      (let* ((ps (send self :num-points)))
        (send self :clear-lines :draw nil)
        (send self :add-lines (send self :point-coordinate 0 (iseq ps))
              (send self :point-coordinate 1 (iseq ps)) :color color)
        (send self :redraw)))

    (defmeth stressp :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "The Stress plot shows the fit of the multidimensional scaling model to the dissimilarity data."))
      (when (> num-mats 1)
            (paste-plot-help (format nil " Since there are ~d matrices of data, the fit is to the root-mean-squared data matrix."num-mats)))
      (paste-plot-help (format nil " The fit is shown for a ~d-dimensional model, since this is the dimensionality you specified. The fit is shown for each iteration. Initially, there is just one value shown.~2%" num-dims))

      (if (= 1 (send stressp :num-points))
          (paste-plot-help (format nil "Currently, the fit is shown for just the initial solution. You can start the iterative process by clicking on the ITERATE button in the STIMULUS SPACE window~2%"))
          (paste-plot-help (format nil "Currently, the fit is shown for ~d iterations. Additional iterations can be performed by clicking on the ITER button in the STIMULUS SPACE window.~2%"(send stressp :num-points))))

      (paste-plot-help (format nil "The Stress plot is used to help you decide whether more iterations are needed to obtain a stable solution. As the iterations proceed, the positions of the stimulus points, as shown in the STIMULUS PLANE MATRIX, STIMULUS SPACE and STIMULUS PLANE plots, become stable, and the Stress value declines slowly, if at all. When this happens, the iterative process has converged on a stable solution, which is ready for interpretation.~2%"))
      (paste-plot-help (format nil "Unfortunately, it is not possible to say what value of Stress represents a good fit. It is known that Stress is effected artifactually by the number of stimuli and the number of dimensions, making it essentially impossible to say whether a particular value is good or bad. You must rely instead on whether the stimulus space, as shown in the STIMULUS PLANE MATRIX, STIMULUS SPACE and STIMULUS PLANE plots, is interpretable."))
      (show-plot-help))

    stressp))

(defmeth rmds-model-proto :mds-x-change-plot (&optional (stream t))
  (let ((num-dims (send self :dimensions))
        (num-mats (length (send self :matrices-numbers)))
        )
    (setf x-changep (plot-points 
                     (iseq (length (send self :x-change-list))) 
                     (send self :x-change-list)
                     :show nil
                     :title "Coordinate Change Plot"
                     :variable-labels (list "Iteration" "X-Change")))
    (send x-changep :margin 0 17 0 0)
    (send x-changep :add-overlay 
          (send vista-graph-overlay-proto 
                :new :mouse-mode nil :new-x nil :new-y nil))
    (send x-changep :showing-labels t)
    ;(send x-changep :point-label 0 
           ;     (format nil "~5,4f" (send stressp :point-coordinate 1 0)))
    (send x-changep :point-label 
          (iseq (send x-changep :num-points))
          (mapcar #'(lambda (st) (format nil "~5,4f" st)) 
                  (send self :stress-list)))
    (send x-changep :point-state 0 'selected)
    (send x-changep :use-color t)
    (send x-changep :point-color 0 'red)
    (send x-changep :mouse-mode 'brushing)
    (send x-changep :range 0 0 5)
    (send x-changep :x-axis t t 6)
    (send x-changep :menu nil)
    (send x-changep :legend2 "Coordinate Change Plot")
    (send x-changep :add-lines 
          (iseq (length (send self :x-change-list))) 
          (send self :x-change-list)
          :color 'red)
    (send x-changep :adjust-to-data)

    (defmeth x-changep :redraw ()
      (let* ((maxy (max (send x-changep :point-coordinate 1 
                              (iseq (send x-changep :num-points)))))
             (gnrx nil)
             )
        (when (> (send self :num-points) (second (send self :range 0)))
              (setf gnrx 
                    (get-nice-range 0 (+ 5 (second (send self :range 0))) 5))
              (send self :range 0 (first gnrx) (second gnrx) :draw nil)
              (send self :x-axis t t (third gnrx) :draw nil))
        (send x-changep :range 1 0  (* .1 (ceiling (* 10 maxy))) :draw nil)
        (send x-changep :y-axis t t (1+   (ceiling (* 10 maxy))) :draw nil)
        (call-next-method)))

    (defmeth x-changep :add-lines-with-points (&key (color 'black))
      (let* ((ps (send self :num-points)))
        (send self :clear-lines :draw nil)
        (send self :add-lines (send self :point-coordinate 0 (iseq ps))
              (send self :point-coordinate 1 (iseq ps)) :color color)
        (send self :redraw)))

    (defmeth x-changep :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "The Stress plot shows the fit of the multidimensional scaling model to the dissimilarity data."))
      (when (> num-mats 1)
            (paste-plot-help (format nil " Since there are ~d matrices of data, the fit is to the root-mean-squared data matrix."num-mats)))
      (paste-plot-help (format nil " The fit is shown for a ~d-dimensional model, since this is the dimensionality you specified. The fit is shown for each iteration. Initially, there is just one value shown.~2%" num-dims))

      (if (= 1 (send x-changep :num-points))
          (paste-plot-help (format nil "Currently, the fit is shown for just the initial solution. You can start the iterative process by clicking on the ITERATE button in the STIMULUS SPACE window~2%"))
          (paste-plot-help (format nil "Currently, the fit is shown for ~d iterations. Additional iterations can be performed by clicking on the ITER button in the STIMULUS SPACE window.~2%"(send stressp :num-points))))

      (paste-plot-help (format nil "The Stress plot is used to help you decide whether more iterations are needed to obtain a stable solution. As the iterations proceed, the positions of the stimulus points, as shown in the STIMULUS PLANE MATRIX, STIMULUS SPACE and STIMULUS PLANE plots, become stable, and the Stress value declines slowly, if at all. When this happens, the iterative process has converged on a stable solution, which is ready for interpretation.~2%"))
      (paste-plot-help (format nil "Unfortunately, it is not possible to say what value of Stress represents a good fit. It is known that Stress is effected artifactually by the number of stimuli and the number of dimensions, making it essentially impossible to say whether a particular value is good or bad. You must rely instead on whether the stimulus space, as shown in the STIMULUS PLANE MATRIX, STIMULUS SPACE and STIMULUS PLANE plots, is interpretable."))
      (show-plot-help))

    x-changep))


(defmeth rmds-model-proto :plot-data-dist ()
  (let* (
         (dist-list (send self :matrices-to-list (list (send self :D))))
         (data-list (send self :matrices-to-list (send self :T-Data)))
         (m (/ (length data-list) (length dist-list)))
         (O (send self :data))
         (D (send self :D))
         (results nil)
         (tran-list nil)
         (pp nil)
         )
    (when (not (send self :monotone))
          (setf pp (plot-points data-list (repeat dist-list m)
                             :title "Fit and Transformation Plot"
                             :location (list 300 40)
                                :variable-labels (list "Data" "Distances")
                                :show nil))
          (send pp :adjust-to-data))
   (when (send self :monotone) 
         (setf results (send self :r-LSMTransform O D))
         (setf tran-list (combine (third results)))
         (setf data-list (combine (second results)))
         (setf dist-list (combine (fourth results)))
         (setf pp (plot-points data-list dist-list
                               :title "Fit and Transformation Plot"
                               :location (list 300 40)
                               :variable-labels (list "Data" "Distances & Transformed Data")
                               :show nil))
         (send pp :add-lines data-list tran-list :color 'red)
         (send pp :adjust-to-data)
         )
    (send pp :point-symbol (iseq (send pp :num-points)) 'square)
    (send pp :use-color t)
    (send pp :point-color (iseq (send pp :num-points)) 'blue)
    (send pp :showing-labels t)
    (send pp :margin 0 17 0 0)
    (send pp :add-overlay (send vista-graph-overlay-proto 
                                :new :new-x nil :new-y nil :undo t))
    (send pp :redraw)
    pp))


(defmeth rmds-model-proto :name-plot (&optional (stream t))
  (setf np (name-list (send self :stimulus-names)
                      :show nil
                      :title "Stimuli"
                      ))
  (send (send np :menu) :title "Stimuli")
  (send np :fix-name-list)
  (send np :use-color t)
  (send np :point-color (iseq (send np :num-points)) 'blue)
  ;(send np :has-h-scroll (max (screen-size)))
  ;(send np :has-v-scroll (max (screen-size)))
  (send np :linked t)
  np)


